/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.lake;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import corgitaco.corgilib.world.level.RandomTickScheduler;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.util.UnsafeBoundingBox;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructurePieceTypes;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;

public class LargeLakePiece
extends StructurePiece {
    private final BlockPos origin;
    private final int radius;
    private final int lakeDepth;
    private final HolderSet<PlacedFeature> lakeFeatures;

    protected LargeLakePiece(BlockPos origin, int radius, int lakeDepth, BoundingBox boundingBox, HolderSet<PlacedFeature> lakeFeatures) {
        super(BWGStructurePieceTypes.LARGE_LAKE.get(), 0, boundingBox);
        this.origin = origin;
        this.radius = radius;
        this.lakeDepth = lakeDepth;
        this.lakeFeatures = lakeFeatures;
    }

    public LargeLakePiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super(BWGStructurePieceTypes.LARGE_LAKE.get(), tag);
        this.origin = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("origin"));
        this.radius = tag.m_128451_("radius");
        this.lakeDepth = tag.m_128451_("lakeDepth");
        RegistryOps tagRegistryOps = RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)context.f_192763_());
        this.lakeFeatures = (HolderSet)((Pair)PlacedFeature.f_191774_.decode((DynamicOps)tagRegistryOps, (Object)tag.m_128423_("lake_features")).getOrThrow(false, error -> BiomesWeveGone.LOGGER.error("[Large Lake Piece]: Error serializing placed features: %s".formatted(error)))).getFirst();
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        tag.m_128365_("origin", (Tag)NbtUtils.m_129224_((BlockPos)this.origin));
        tag.m_128405_("radius", this.radius);
        tag.m_128405_("lakeDepth", this.lakeDepth);
        RegistryOps tagRegistryOps = RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)context.f_192763_());
        tag.m_128365_("lake_features", (Tag)PlacedFeature.f_191774_.encodeStart((DynamicOps)tagRegistryOps, this.lakeFeatures).result().orElseThrow());
    }

    public void m_213694_(WorldGenLevel worldGenLevel, @NotNull StructureManager structureManager, @NotNull ChunkGenerator generator, @NotNull RandomSource random, @NotNull BoundingBox box, ChunkPos chunkPos, @NotNull BlockPos pos) {
        ImprovedNoise noiseSampler = new ImprovedNoise((RandomSource)new XoroshiroRandomSource(worldGenLevel.m_7328_()));
        UnsafeBoundingBox unsafeBoundingBox = new UnsafeBoundingBox();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        ChunkAccess chunk = worldGenLevel.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
        boolean[] placedWater = new boolean[256];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int blockX = chunkPos.m_151382_(x);
                int blockZ = chunkPos.m_151391_(z);
                mutableBlockPos.m_122178_(blockX, 0, blockZ);
                NoiseProvider stateProvider = new NoiseProvider(worldGenLevel.m_7328_(), (NormalNoise.NoiseParameters)((HolderLookup.RegistryLookup)worldGenLevel.m_9598_().m_254861_(Registries.f_256865_).orElseThrow()).m_255043_(Noises.f_189261_).m_203334_(), 0.5f, List.of(Blocks.f_49994_.m_49966_(), Blocks.f_220864_.m_49966_(), Blocks.f_50129_.m_49966_()));
                int worldSurfaceY = worldGenLevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, blockX, blockZ);
                double radiusFrequency = 0.05;
                double noise = noiseSampler.m_164308_((double)blockX * radiusFrequency, 0.0, (double)blockZ * radiusFrequency) + 1.0;
                double localRadius = (int)Mth.m_14085_((double)((double)this.radius * 0.5), (double)this.radius, (double)(noise * 0.5));
                int blendWidth = 43;
                int rimSize = (int)(localRadius * 0.05);
                int fluidDepth = 1;
                BlockState[] topBlocks = LargeLakePiece.getSurfaceBlocks(mutableBlockPos, blockX, blockZ, worldSurfaceY, chunk);
                this.blendTerrainChecked(mutableBlockPos, localRadius, blendWidth, worldSurfaceY, blockX, blockZ, chunk, topBlocks, unsafeBoundingBox);
                placedWater[x + z * 16] = this.buildLakeChecked(worldGenLevel, random, mutableBlockPos, localRadius, blendWidth, rimSize, noiseSampler, fluidDepth, blockX, blockZ, chunk, (BlockStateProvider)stateProvider, topBlocks, unsafeBoundingBox);
            }
        }
        if (unsafeBoundingBox.valid()) {
            this.f_73383_ = unsafeBoundingBox.toBoundingBox();
        }
        SectionPos sectionPos = SectionPos.m_123196_((ChunkPos)chunkPos, (int)worldGenLevel.m_151560_());
        BlockPos blockPos = sectionPos.m_123249_();
        Predicate<BlockPos> test = blockPos1 -> {
            int localX = blockPos1.m_123341_() & 0xF;
            int localZ = blockPos1.m_123343_() & 0xF;
            return placedWater[localX + localZ * 16];
        };
        for (Holder lakeFeature : this.lakeFeatures) {
            this.placeWithContext(new PlacementContext(worldGenLevel, generator, Optional.empty()), random, blockPos, (PlacedFeature)lakeFeature.m_203334_(), test);
        }
    }

    private boolean placeWithContext(PlacementContext context, RandomSource source, BlockPos pos, PlacedFeature feature, Predicate<BlockPos> placingPos) {
        Stream<Object> stream = Stream.of(pos);
        for (PlacementModifier placementModifier : feature.f_191776_()) {
            stream = stream.flatMap(blockPos -> placementModifier.m_213676_(context, source, blockPos));
        }
        ConfiguredFeature configuredFeature = (ConfiguredFeature)feature.f_191775_().m_203334_();
        MutableBoolean mutableBoolean = new MutableBoolean();
        stream.forEach(blockPos -> {
            if (placingPos.test((BlockPos)blockPos) && configuredFeature.m_224953_(context.m_191831_(), context.m_191833_(), source, blockPos)) {
                mutableBoolean.setTrue();
            }
        });
        return mutableBoolean.isTrue();
    }

    private boolean buildLakeChecked(WorldGenLevel worldGenLevel, RandomSource random, BlockPos.MutableBlockPos mutableBlockPos, double localRadius, int blendWidth, int rimSize, ImprovedNoise noiseSampler, int waterLevel, int blockX, int blockZ, ChunkAccess chunk, BlockStateProvider stateProvider, BlockState[] topBlocks, UnsafeBoundingBox unsafeBoundingBox) {
        if (mutableBlockPos.m_142448_(this.origin.m_123342_()).m_123314_((Vec3i)this.origin, localRadius - (double)blendWidth - (double)rimSize)) {
            return this.buildLake(worldGenLevel, random, localRadius, blendWidth, rimSize, mutableBlockPos, noiseSampler, waterLevel, blockX, blockZ, chunk, stateProvider, topBlocks, unsafeBoundingBox);
        }
        return false;
    }

    private boolean buildLake(WorldGenLevel worldGenLevel, RandomSource random, double localRadius, int blendWidth, int rimSize, BlockPos.MutableBlockPos mutableBlockPos, ImprovedNoise noiseSampler, int fluidLevel, int blockX, int blockZ, ChunkAccess chunk, BlockStateProvider stateProvider, BlockState[] topBlocks, UnsafeBoundingBox unsafeBoundingBox) {
        boolean placedWater = false;
        double offset = localRadius - (double)blendWidth - (double)rimSize;
        double delta = (mutableBlockPos.m_142448_(this.origin.m_123342_()).m_123331_((Vec3i)this.origin) - Mth.m_144952_((double)offset)) / Mth.m_144952_((double)(localRadius - offset));
        float frequency = 0.05f;
        double depthNoise = (noiseSampler.m_164308_((double)((float)(mutableBlockPos.m_123341_() + 100000) * frequency), 0.0, (double)((float)(mutableBlockPos.m_123343_() + 100000) * frequency)) + 1.0) * 0.5;
        double depthOffset = Mth.m_14085_((double)0.0, (double)10.0, (double)depthNoise);
        int minGenY = this.origin.m_123342_() - this.lakeDepth;
        int waterGenY = this.origin.m_123342_() - fluidLevel;
        int depth = (int)Mth.m_14085_((double)this.origin.m_123342_(), (double)((double)minGenY - depthOffset), (double)(-delta));
        for (int y = this.origin.m_123342_(); y >= depth - 1; --y) {
            mutableBlockPos.m_122178_(blockX, y, blockZ);
            if (y == depth - 1) {
                chunk.m_6978_((BlockPos)mutableBlockPos, Blocks.f_50069_.m_49966_(), false);
            } else if (y <= depth + 3) {
                if (y < waterGenY) {
                    chunk.m_6978_((BlockPos)mutableBlockPos, stateProvider.m_213972_(random, (BlockPos)mutableBlockPos), false);
                } else {
                    chunk.m_6978_((BlockPos)mutableBlockPos, topBlocks[Math.min(this.origin.m_123342_() - y, topBlocks.length - 1)], false);
                    ((RandomTickScheduler)chunk).scheduleRandomTick(mutableBlockPos.m_7949_());
                    chunk.m_8113_((BlockPos)mutableBlockPos);
                }
            } else if (y > waterGenY) {
                chunk.m_6978_((BlockPos)mutableBlockPos, Blocks.f_50016_.m_49966_(), false);
            } else {
                placedWater = true;
                chunk.m_6978_((BlockPos)mutableBlockPos, Blocks.f_49990_.m_49966_(), false);
                worldGenLevel.m_186469_(mutableBlockPos.m_7949_(), (Fluid)Fluids.f_76193_, 0);
            }
            unsafeBoundingBox.encapsulate((Vec3i)mutableBlockPos);
        }
        return placedWater;
    }

    private void blendTerrainChecked(BlockPos.MutableBlockPos mutableBlockPos, double localRadius, int blendWidth, int worldSurfaceY, int blockX, int blockZ, ChunkAccess chunk, BlockState[] topBlocks, UnsafeBoundingBox unsafeBoundingBox) {
        if (mutableBlockPos.m_142448_(this.origin.m_123342_()).m_123314_((Vec3i)this.origin, localRadius)) {
            this.blendTerrain(localRadius, blendWidth, mutableBlockPos, worldSurfaceY, blockX, blockZ, chunk, topBlocks, unsafeBoundingBox);
        }
    }

    private void blendTerrain(double localRadius, int blendWidth, BlockPos.MutableBlockPos mutableBlockPos, int worldSurfaceY, int blockX, int blockZ, ChunkAccess chunk, BlockState[] topBlocks, UnsafeBoundingBox unsafeBoundingBox) {
        int y;
        double offset = localRadius - (double)blendWidth;
        double delta = (mutableBlockPos.m_142448_(this.origin.m_123342_()).m_123331_((Vec3i)this.origin) - Mth.m_144952_((double)offset)) / Mth.m_144952_((double)(localRadius - offset));
        int height = (int)Mth.m_14085_((double)this.origin.m_123342_(), (double)worldSurfaceY, (double)delta);
        if (this.origin.m_123342_() >= worldSurfaceY) {
            for (y = worldSurfaceY; y <= height; ++y) {
                mutableBlockPos.m_122178_(blockX, y, blockZ);
                chunk.m_6978_((BlockPos)mutableBlockPos, topBlocks[topBlocks.length - 1], false);
                unsafeBoundingBox.encapsulate((Vec3i)mutableBlockPos);
            }
        } else {
            for (y = worldSurfaceY; y > height; --y) {
                mutableBlockPos.m_122178_(blockX, y, blockZ);
                chunk.m_6978_((BlockPos)mutableBlockPos, Blocks.f_50016_.m_49966_(), false);
                unsafeBoundingBox.encapsulate((Vec3i)mutableBlockPos);
            }
        }
        for (y = 0; y < topBlocks.length; ++y) {
            mutableBlockPos.m_122178_(blockX, height - y, blockZ);
            chunk.m_6978_((BlockPos)mutableBlockPos, topBlocks[y], false);
            ((RandomTickScheduler)chunk).scheduleRandomTick(mutableBlockPos.m_7949_());
            chunk.m_8113_((BlockPos)mutableBlockPos);
        }
    }

    private static BlockState @NotNull [] getSurfaceBlocks(BlockPos.MutableBlockPos mutableBlockPos, int blockX, int blockZ, int worldSurfaceY, ChunkAccess chunk) {
        BlockState[] topBlocks = new BlockState[]{Blocks.f_50440_.m_49966_(), Blocks.f_50493_.m_49966_(), Blocks.f_50493_.m_49966_(), Blocks.f_50069_.m_49966_(), Blocks.f_50069_.m_49966_()};
        for (int y = 0; y < topBlocks.length; ++y) {
            mutableBlockPos.m_122178_(blockX, worldSurfaceY - y, blockZ);
            BlockState blockState = chunk.m_8055_((BlockPos)mutableBlockPos);
            if (blockState.m_60795_() || !blockState.m_60819_().m_76178_()) continue;
            topBlocks[y] = blockState;
        }
        return topBlocks;
    }
}

